function gatherSettings() {
    return {
        extensionEnabled: document.getElementById('masterToggle').checked,
        enabled: document.getElementById('toggleFont').checked,
        fontSize: document.getElementById('fontSize').value + 'px',
        lineSpacing: document.getElementById('lineSpacing').value,
        letterSpacing: document.getElementById('letterSpacing').value + 'em',
        wordSpacing: document.getElementById('wordSpacing').value + 'em'
    };
}

const masterToggle = document.getElementById('masterToggle');
const mainSettings = document.getElementById('mainSettings');
const applyButton = document.getElementById('apply');

masterToggle.addEventListener('change', () => { 
    const isEnabled = masterToggle.checked;
    mainSettings.style.display = isEnabled ? 'block' : 'none';

    // Persist extensionEnabled
    browser.storage.local.set({ extensionEnabled: isEnabled });

    browser.tabs.query({ active: true, currentWindow: true }).then((tabs) => {
        if (!tabs[0]) return;

        if (!isEnabled) {
            // Turn everything off on the page
            browser.tabs.sendMessage(tabs[0].id, { type: "DISABLE_STYLES" });
        } else {
            // When enabling, immediately apply current settings
            const settings = gatherSettings();
            browser.storage.local.set(settings);
            browser.tabs.sendMessage(tabs[0].id, { type: "APPLY_SETTINGS", settings });
        }
    });
});

applyButton.addEventListener('click', () => {
    const settings = gatherSettings();
    browser.storage.local.set(settings);
    browser.tabs.query({ active: true, currentWindow: true }).then((tabs) => {
        if (!tabs[0]) return;
        browser.tabs.sendMessage(tabs[0].id, { type: "APPLY_SETTINGS", settings });
    });
});

// Initialize UI from stored settings
browser.storage.local.get().then((settings) => {
    const enabled = settings.extensionEnabled || false;
    masterToggle.checked = enabled;
    mainSettings.style.display = enabled ? 'block' : 'none';

    document.getElementById('toggleFont').checked = settings.enabled || false;
    document.getElementById('fontSize').value = parseInt(settings.fontSize || '16');
    document.getElementById('lineSpacing').value = parseFloat(settings.lineSpacing || '1.6');
    document.getElementById('letterSpacing').value = parseFloat(settings.letterSpacing || '0.12');
    document.getElementById('wordSpacing').value = parseFloat(settings.wordSpacing || '0.16');
});
