function clearDyslexicStyles() {
    const existingStyle = document.getElementById("dyslexic-style");
    if (existingStyle) existingStyle.remove();

    const fontLink = document.getElementById("dyslexic-font-link");
    if (fontLink) fontLink.remove();
}

function applyDyslexiaSettings(settings) {
    clearDyslexicStyles();
 
    if (!settings || !settings.extensionEnabled) {
        // Extension is off; nothing to apply
        return;
    }

    // Optionally load OpenDyslexic font
    if (settings.enabled) {
        const link = document.createElement("link");
        link.id = "dyslexic-font-link";
        link.rel = "stylesheet";
        link.href = "https://cdn.jsdelivr.net/gh/antijingoist/open-dyslexic/webkit/OpenDyslexic.css";
        document.head.appendChild(link);
    }

    const style = document.createElement("style");
    style.id = "dyslexic-style";

    const fontFamilyRule = settings.enabled
    ? "font-family: 'OpenDyslexic', sans-serif !important;"
    : "";

    style.innerText = `
    body, * {
        ${fontFamilyRule}
        font-size: ${settings.fontSize || '16px'} !important;
        line-height: ${settings.lineSpacing || '1.6'} !important;
        letter-spacing: ${settings.letterSpacing || '0.12em'} !important;
        word-spacing: ${settings.wordSpacing || '0.16em'} !important;
    }
    `;
    document.head.appendChild(style);
}

// Listen for messages from popup
browser.runtime.onMessage.addListener((message) => {
    if (message.type === "APPLY_SETTINGS") {
        applyDyslexiaSettings(message.settings);
    } else if (message.type === "DISABLE_STYLES") {
        clearDyslexicStyles();
    }
});

// Apply saved settings on page load
browser.storage.local.get().then((settings) => {
    applyDyslexiaSettings(settings);
});
